/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.saveAndContinue;

import com.megacrit.cardcrawl.cards.CardSave;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.CardHelper;
import com.megacrit.cardcrawl.helpers.EventHelper;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.relics.BottledFlame;
import com.megacrit.cardcrawl.relics.BottledLightning;
import com.megacrit.cardcrawl.relics.BottledTornado;
import com.megacrit.cardcrawl.rewards.RewardItem;
import com.megacrit.cardcrawl.rewards.RewardSave;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.shop.ShopScreen;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaveFile {
    private static final Logger logger = LogManager.getLogger(SaveFile.class.getName());
    public String name;
    public String loadout;
    public int current_health;
    public int max_health;
    public int gold;
    public int hand_size;
    public int red;
    public int green;
    public int blue;
    public ArrayList<CardSave> cards;
    public HashMap<String, Integer> obtained_cards;
    public ArrayList<String> relics;
    public ArrayList<Integer> relic_counters;
    public ArrayList<String> potions;
    public boolean chose_neow_reward;
    public boolean is_hardmode;
    public String level_name;
    public long play_time;
    public long save_date;
    public int floor_num;
    public long seed;
    public int monster_seed_count;
    public int event_seed_count;
    public int merchant_seed_count;
    public int card_seed_count;
    public int treasure_seed_count;
    public int relic_seed_count;
    public int potion_seed_count;
    public int monster_hp_seed_count;
    public int ai_seed_count;
    public int shuffle_seed_count;
    public int card_random_seed_count;
    public int potion_chance;
    public int purgeCost;
    public ArrayList<String> monster_list;
    public ArrayList<String> elite_monster_list;
    public ArrayList<String> boss_list;
    public ArrayList<String> event_list;
    public ArrayList<String> one_time_event_list;
    public ArrayList<Float> event_chances;
    public ArrayList<Integer> path_x;
    public ArrayList<Integer> path_y;
    public int room_x;
    public int room_y;
    public int spirit_count;
    public String boss;
    public String current_room;
    public ArrayList<String> common_relics;
    public ArrayList<String> uncommon_relics;
    public ArrayList<String> rare_relics;
    public ArrayList<String> shop_relics;
    public ArrayList<String> boss_relics;
    public String bottled_flame;
    public String bottled_lightning;
    public String bottled_tornado;
    public boolean post_combat;
    public ArrayList<RewardSave> combat_rewards;
    public int monsters_killed;
    public int elites_killed;
    public int metric_campfire_rested;
    public int metric_campfire_upgraded;
    public int metric_campfire_rituals;
    public int metric_campfire_meditates;
    public int metric_purchased_purges;
    public ArrayList<Integer> metric_potions_floor_spawned;
    public ArrayList<Integer> metric_potions_floor_usage;
    public ArrayList<Integer> metric_current_hp_per_floor;
    public ArrayList<Integer> metric_max_hp_per_floor;
    public ArrayList<Integer> metric_gold_per_floor;
    public ArrayList<String> metric_path_per_floor;
    public ArrayList<String> metric_path_taken;
    public ArrayList<String> metric_items_purchased;
    public ArrayList<String> metric_items_purged;
    public ArrayList<HashMap> metric_card_choices;
    public ArrayList<HashMap> metric_event_choices;
    public ArrayList<HashMap> metric_boss_relics;
    public ArrayList<HashMap> metric_damage_taken;
    public String metric_build_version;
    public String metric_seed_played;
    public int metric_floor_reached;
    public long metric_playtime;

    public SaveFile() {
    }

    public SaveFile(SaveType type) {
        AbstractPlayer p = AbstractDungeon.player;
        this.name = p.name;
        this.current_health = p.currentHealth;
        this.max_health = p.maxHealth;
        this.gold = p.gold;
        this.hand_size = p.masterHandSize;
        this.red = p.energy.energyMaster;
        this.green = 0;
        this.blue = 0;
        this.monsters_killed = CardCrawlGame.monstersSlain;
        this.elites_killed = CardCrawlGame.elitesSlain;
        this.cards = p.masterDeck.getCardDeck();
        this.obtained_cards = CardHelper.obtainedCards;
        this.relics = new ArrayList();
        this.relic_counters = new ArrayList();
        for (AbstractRelic r : p.relics) {
            this.relics.add(r.relicId);
            this.relic_counters.add(r.counter);
        }
        this.potions = new ArrayList();
        this.potions.add(AbstractDungeon.player.potions[0].ID);
        this.potions.add(AbstractDungeon.player.potions[1].ID);
        this.potions.add(AbstractDungeon.player.potions[2].ID);
        this.is_hardmode = false;
        this.chose_neow_reward = false;
        this.level_name = AbstractDungeon.id;
        this.floor_num = AbstractDungeon.floorNum;
        this.monster_list = AbstractDungeon.monsterList;
        this.elite_monster_list = AbstractDungeon.eliteMonsterList;
        this.boss_list = AbstractDungeon.bossList;
        this.event_list = AbstractDungeon.eventList;
        this.one_time_event_list = AbstractDungeon.specialOneTimeEventList;
        this.potion_chance = AbstractRoom.blizzardPotionMod;
        this.event_chances = EventHelper.getChances();
        this.play_time = System.currentTimeMillis() / 1000L - AbstractDungeon.playtimeStart;
        this.save_date = Calendar.getInstance().getTimeInMillis();
        this.seed = Settings.seed;
        this.boss = AbstractDungeon.bossKey;
        this.purgeCost = ShopScreen.purgeCost;
        this.monster_seed_count = AbstractDungeon.monsterRng.counter;
        this.event_seed_count = AbstractDungeon.eventRng.counter;
        this.merchant_seed_count = AbstractDungeon.merchantRng.counter;
        this.card_seed_count = AbstractDungeon.cardRng.counter;
        this.treasure_seed_count = AbstractDungeon.treasureRng.counter;
        this.relic_seed_count = AbstractDungeon.relicRng.counter;
        this.potion_seed_count = AbstractDungeon.potionRng.counter;
        this.path_x = AbstractDungeon.pathX;
        this.path_y = AbstractDungeon.pathY;
        if (AbstractDungeon.nextRoom == null) {
            this.room_x = AbstractDungeon.getCurrMapNode().x;
            this.room_y = AbstractDungeon.getCurrMapNode().y;
            this.current_room = AbstractDungeon.getCurrRoom().getClass().getName();
        } else {
            this.room_x = AbstractDungeon.nextRoom.x;
            this.room_y = AbstractDungeon.nextRoom.y;
            this.current_room = AbstractDungeon.nextRoom.room.getClass().getName();
        }
        this.spirit_count = AbstractDungeon.bossCount;
        logger.info("Next Room: " + this.current_room);
        this.common_relics = AbstractDungeon.commonRelicPool;
        this.uncommon_relics = AbstractDungeon.uncommonRelicPool;
        this.rare_relics = AbstractDungeon.rareRelicPool;
        this.shop_relics = AbstractDungeon.shopRelicPool;
        this.boss_relics = AbstractDungeon.bossRelicPool;
        this.post_combat = false;
        switch (type) {
            case AFTER_BOSS_RELIC: {
                break;
            }
            case ENTER_ROOM: {
                break;
            }
            case POST_COMBAT: {
                this.post_combat = true;
                this.combat_rewards = new ArrayList();
                for (RewardItem i : AbstractDungeon.getCurrRoom().rewards) {
                    switch (i.type) {
                        case CARD: {
                            this.combat_rewards.add(new RewardSave(i.type.toString(), null));
                            break;
                        }
                        case GOLD: {
                            this.combat_rewards.add(new RewardSave(i.type.toString(), null, i.goldAmt, i.bonusGold));
                            break;
                        }
                        case POTION: {
                            this.combat_rewards.add(new RewardSave(i.type.toString(), i.potion.ID));
                            break;
                        }
                        case RELIC: {
                            this.combat_rewards.add(new RewardSave(i.type.toString(), i.relic.relicId));
                            break;
                        }
                        case STOLEN_GOLD: {
                            this.combat_rewards.add(new RewardSave(i.type.toString(), null, i.goldAmt, 0));
                            break;
                        }
                    }
                }
                break;
            }
            case POST_NEOW: {
                this.chose_neow_reward = true;
                break;
            }
        }
        this.bottled_flame = AbstractDungeon.player.hasRelic("Bottled Flame") ? ((BottledFlame)AbstractDungeon.player.getRelic((String)"Bottled Flame")).card.cardID : null;
        this.bottled_lightning = AbstractDungeon.player.hasRelic("Bottled Lightning") ? ((BottledLightning)AbstractDungeon.player.getRelic((String)"Bottled Lightning")).card.cardID : null;
        this.bottled_tornado = AbstractDungeon.player.hasRelic("Bottled Tornado") ? ((BottledTornado)AbstractDungeon.player.getRelic((String)"Bottled Tornado")).card.cardID : null;
        this.metric_campfire_rested = CardCrawlGame.metricData.campfire_rested;
        this.metric_campfire_upgraded = CardCrawlGame.metricData.campfire_upgraded;
        this.metric_campfire_rituals = CardCrawlGame.metricData.campfire_rituals;
        this.metric_campfire_meditates = CardCrawlGame.metricData.campfire_meditates;
        this.metric_purchased_purges = CardCrawlGame.metricData.purchased_purges;
        this.metric_potions_floor_spawned = CardCrawlGame.metricData.potions_floor_spawned;
        this.metric_potions_floor_usage = CardCrawlGame.metricData.potions_floor_usage;
        this.metric_current_hp_per_floor = CardCrawlGame.metricData.current_hp_per_floor;
        this.metric_max_hp_per_floor = CardCrawlGame.metricData.max_hp_per_floor;
        this.metric_gold_per_floor = CardCrawlGame.metricData.gold_per_floor;
        this.metric_path_per_floor = CardCrawlGame.metricData.path_per_floor;
        this.metric_path_taken = CardCrawlGame.metricData.path_taken;
        this.metric_items_purchased = CardCrawlGame.metricData.items_purchased;
        this.metric_items_purged = CardCrawlGame.metricData.items_purged;
        this.metric_card_choices = CardCrawlGame.metricData.card_choices;
        this.metric_event_choices = CardCrawlGame.metricData.event_choices;
        this.metric_boss_relics = CardCrawlGame.metricData.boss_relics;
        this.metric_damage_taken = CardCrawlGame.metricData.damage_taken;
        this.metric_build_version = CardCrawlGame.TRUE_VERSION_NUM;
        this.metric_seed_played = Settings.seed.toString();
        this.metric_floor_reached = AbstractDungeon.floorNum;
        long lastPlaytimeEnd = System.currentTimeMillis() / 1000L;
        this.metric_playtime = lastPlaytimeEnd - AbstractDungeon.playtimeStart;
    }

    public static enum SaveType {
        ENTER_ROOM,
        POST_NEOW,
        POST_COMBAT,
        AFTER_BOSS_RELIC;

    }
}

